"use strict";

var _react = _interopRequireDefault(require("react"));
var _immutable = _interopRequireDefault(require("immutable"));
var _testUtils = require("testUtils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var getComponent = function getComponent() {
  return require('ui/box/chrome').default;
};
jest.mock('ui/box/header', function () {
  return (0, _testUtils.mockComponent)('header');
});
jest.mock('ui/box/multisize_slide', function () {
  return (0, _testUtils.mockComponent)('div');
});
jest.mock('ui/box/global_message', function () {
  return (0, _testUtils.mockComponent)('div');
});
var mockEventRegister = {};
var triggerEvent = function triggerEvent(name) {
  if (name in mockEventRegister) {
    return mockEventRegister[name]();
  }
  throw new Error("Unknown event '".concat(name, "'"));
};
jest.mock('core/index', function () {
  return {
    handleEvent: jest.fn(function (_, event, fn) {
      mockEventRegister[event] = fn;
    }),
    ui: {
      forceAutoHeight: jest.fn().mockReturnValue(false)
    },
    id: jest.fn(function () {
      return 'lock';
    })
  };
});
var defaultProps = {
  contentComponent: (0, _testUtils.mockComponent)('content'),
  contentProps: {
    model: _immutable.default.fromJS({
      id: '__lock_id__'
    })
  },
  avatar: 'avatar',
  isSubmitting: false,
  logo: 'logo',
  primaryColor: 'white',
  screenName: 'screen name',
  classNames: '',
  color: 'black'
};
describe('Chrome', function () {
  var Chrome;
  beforeEach(function () {
    Chrome = getComponent();
    Chrome.prototype.getHeaderSize = jest.fn(function () {
      return 200;
    });
    mockEventRegister = {};
  });
  it('renders correctly with basic props', function () {
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, defaultProps)).toMatchSnapshot();
  });
  it('renders correctly when there is a global message', function () {
    var props = _objectSpread(_objectSpread({}, defaultProps), {}, {
      error: 'There is an error'
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, props)).toMatchSnapshot();
  });
  it('renders correctly when there is a global success message', function () {
    var props = _objectSpread(_objectSpread({}, defaultProps), {}, {
      success: 'This is a success message'
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, props)).toMatchSnapshot();
  });
  it('renders correctly when there is a global information message', function () {
    var props = _objectSpread(_objectSpread({}, defaultProps), {}, {
      info: 'This is an information message'
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, props)).toMatchSnapshot();
  });
  it('can dislay all global messages together', function () {
    var props = _objectSpread(_objectSpread({}, defaultProps), {}, {
      info: 'This is an information message',
      success: 'This is a success message',
      error: 'There is an error'
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, props)).toMatchSnapshot();
  });
  it('adds the auto-height class when forceAutoHeight UI prop is true', function () {
    require('core/index').ui.forceAutoHeight.mockReturnValue(true);
    var props = _objectSpread(_objectSpread({}, defaultProps), {}, {
      info: 'This is an information message',
      success: 'This is a success message',
      error: 'There is an error'
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Chrome, props)).toMatchSnapshot();
  });
});
