"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _immutable = _interopRequireDefault(require("immutable"));
var _flat = _interopRequireDefault(require("flat"));
var _en = _interopRequireDefault(require("../i18n/en"));
var _es = _interopRequireDefault(require("../i18n/es"));
var sync = _interopRequireWildcard(require("../sync"));
var l = _interopRequireWildcard(require("../core/index"));
var _sanitizer = require("../sanitizer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
describe('i18n', function () {
  var syncSpy;
  var langSpy;
  beforeEach(function () {
    syncSpy = jest.spyOn(sync, 'default');
    langSpy = jest.spyOn(l.ui, 'language').mockImplementation(function () {
      return 'en';
    });
  });
  afterEach(function () {
    syncSpy.mockRestore();
    langSpy.mockRestore();
  });
  describe('load i18n configuration', function () {
    it('should have a defaultDictionary', function () {
      var i18n = require('../i18n');

      // We need to initialize the state
      var m = _immutable.default.fromJS({});

      // Initialize i18n.
      var initialized = i18n.initI18n(m);
      var language = (0, _flat.default)(initialized.getIn(['i18n', 'strings']).toJS());
      var en = (0, _flat.default)(_en.default);
      expect(language).toEqual(en);
    });
  });
  describe('when en language is selected', function () {
    it('should allow check for external en dictionaries', function () {
      var i18n = require('../i18n');
      i18n.initI18n(_immutable.default.fromJS({}));
      expect(syncSpy).toHaveBeenCalledTimes(1);
    });
  });
  describe('when html is called', function () {
    it('should sanitize the input and not allow for javascript to be passed through', function () {
      var i18n = require('../i18n');
      var strings = {
        test: '<img src=1 href=1 onerror="javascript:alert(1)"></img>'
      };
      var m = _immutable.default.fromJS({
        i18n: {
          strings: strings
        }
      });
      var html = i18n.html(m, 'test');
      expect(html.props.dangerouslySetInnerHTML.__html).not.toMatch(/javascript:alert/);
      expect(html.props.dangerouslySetInnerHTML.__html).toEqual('<img href="1" src="1">');
    });
    it('should allow target=_blank with noopener noreferrer attributes', function () {
      (0, _sanitizer.initSanitizer)();
      var i18n = require('../i18n');
      var strings = {
        test: '<a href="#" target="_blank">link</a>'
      };
      var m = _immutable.default.fromJS({
        i18n: {
          strings: strings
        }
      });
      var html = i18n.html(m, 'test');
      expect(html.props.dangerouslySetInnerHTML.__html).toEqual('<a href="#" target="_blank" rel="noopener noreferrer">link</a>');
    });
  });
});
