"use strict";

var _react = _interopRequireDefault(require("react"));
var _testUtils = require("testUtils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
jest.mock('connection/enterprise');
jest.mock('core/index');
jest.mock('field/social/social_buttons_pane', function () {
  return (0, _testUtils.mockComponent)('social_buttons_pane');
});
jest.mock('field/phone-number/phone_number_pane', function () {
  return (0, _testUtils.mockComponent)('phone_number_pane');
});
jest.mock('field/captcha/captcha_pane', function () {
  return (0, _testUtils.mockComponent)('captcha_pane');
});
jest.mock('core/pane_separator', function () {
  return (0, _testUtils.mockComponent)('pane_separator');
});
jest.mock('connection/database/sign_up_terms', function () {
  return (0, _testUtils.mockComponent)('sign_up_terms');
});
jest.mock('connection/passwordless/index', function () {
  return {
    isEmail: jest.fn()
  };
});
var getComponent = function getComponent() {
  var SocialOrPhoneNumberScreen = require('engine/passwordless/social_or_phone_number_login_screen').default;
  var screen = new SocialOrPhoneNumberScreen();
  return screen.render();
};
describe('sms passwordless', function () {
  beforeEach(function () {
    jest.resetModules();
    jest.resetAllMocks();
    jest.mock('connection/database/index', function () {
      return {
        hasScreen: function hasScreen() {
          return false;
        },
        databaseUsernameValue: jest.fn()
      };
    });
    jest.mock('connection/database/actions', function () {
      return {
        cancelMFALogin: jest.fn(),
        logIn: jest.fn()
      };
    });
    jest.mock('core/signed_in_confirmation', function () {
      return {
        renderSignedInConfirmation: jest.fn()
      };
    });
    jest.mock('connection/enterprise', function () {
      return {
        isHRDEmailValid: jest.fn(function () {
          return false;
        }),
        isHRDDomain: jest.fn(function () {
          return true;
        })
      };
    });
    jest.mock('core/index', function () {
      return {
        hasSomeConnections: jest.fn(function () {
          return true;
        }),
        passwordlessCaptcha: jest.fn()
      };
    });
  });
  var defaultProps = {
    i18n: {
      str: function str() {
        for (var _len = arguments.length, keys = new Array(_len), _key = 0; _key < _len; _key++) {
          keys[_key] = arguments[_key];
        }
        return keys.join(',');
      },
      html: function html() {
        for (var _len2 = arguments.length, keys = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          keys[_key2] = arguments[_key2];
        }
        return keys.join(',');
      }
    },
    model: 'model'
  };
  it('renders correctly', function () {
    var Component = getComponent();
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
  it('renders a captcha', function () {
    var Component = getComponent();
    require('core/index').passwordlessCaptcha.mockReturnValue({
      get: function get() {
        return true;
      }
    });
    (0, _testUtils.expectComponent)( /*#__PURE__*/_react.default.createElement(Component, defaultProps)).toMatchSnapshot();
  });
});
