/// <reference types="node" />
import { EventEmitter } from 'events';
import { CustomError } from '@httptoolkit/util';
import { Interval, SKU, TierCode } from "./types";
export declare class TokenRejectedError extends CustomError {
    constructor();
}
export declare class RefreshRejectedError extends CustomError {
    constructor(response: {
        description: string;
    });
}
export declare const loginEvents: EventEmitter;
export declare const initializeAuthUi: (options?: {
    /**
     * Do we want a persistent refresh token, or just a normal session? Defaults to false.
     */
    refreshToken?: boolean;
    /**
     * Should one-click login be available? Should be enabled for cases where you might log
     * in and out, or be logged out automatically (no refresh token) and disabled for most
     * long-term persistent usage.
     *
     * Defaults to true.
     */
    rememberLastLogin?: boolean;
    /**
     * Allow closing the login UI. This may need to be disabled in some environments (e.g. the dashboard)
     * where the login prompt is modal, not optional.
     *
     * Defaults to true.
     */
    closeable?: boolean;
}) => void;
export declare const showLoginDialog: () => Promise<boolean>;
export declare const hideLoginDialog: () => void | undefined;
export declare const logOut: () => void;
declare function refreshToken(): Promise<string>;
export type SubscriptionStatus = 'active' | 'trialing' | 'past_due' | 'deleted';
interface Subscription {
    status: SubscriptionStatus;
    quantity: number;
    expiry: Date;
    sku: SKU;
    tierCode: TierCode;
    interval: Interval;
    /**
     * Preserved for backward compat - but generally we use `sku` now.
     *
     * @deprecated
     */
    plan: SKU;
    updateBillingDetailsUrl?: string;
    cancelSubscriptionUrl?: string;
    lastReceiptUrl?: string;
    canManageSubscription: boolean;
}
interface BaseAccountData {
    userId?: string;
    email?: string;
    subscription?: Subscription;
    banned: boolean;
}
export interface User extends BaseAccountData {
    featureFlags: string[];
    /**
     * This represents a subscription for which this user is the _owner_
     * but is not a _member_. The user should not be treated as having
     * an active subscription for the main tool.
     */
    teamSubscription?: Subscription;
}
export interface Transaction {
    orderId: string;
    receiptUrl: string;
    sku: SKU;
    createdAt: string;
    status: string;
    currency: string;
    amount: string;
}
export interface TeamMember {
    id: string;
    name: string;
    locked: boolean;
    error?: string;
}
export interface TeamOwner {
    id: string;
    name?: string;
    error?: string;
}
export interface BillingAccount extends BaseAccountData {
    transactions: Transaction[] | null;
    teamOwner?: TeamOwner;
    teamMembers?: TeamMember[];
    lockedLicenseExpiries?: number[];
}
export declare function getLastUserData(): User;
export declare function getLatestUserData(): Promise<User>;
export declare function getBillingData(): Promise<BillingAccount>;
export declare function updateTeamMembers(idsToRemove: string[], emailsToAdd: string[]): Promise<void>;
export declare function cancelSubscription(): Promise<void>;
export {};
