#!/bin/bash
# Generate JWT Signing Key
# This script generates a private key for JWT signing

echo "Generating JWT signing key..."
openssl genrsa -out signing-key.pem 2048

echo ""
echo "Key generated: signing-key.pem"
echo ""
echo "Add this to your .env file as SIGNING_PRIVATE_KEY:"
echo "=========================================="
cat signing-key.pem
echo "=========================================="
echo ""
echo "⚠️  Keep this key secure! Do not commit it to version control."
echo "⚠️  The signing-key.pem file has been created - you can delete it after copying to .env"
