# Quick Deployment Instructions

## ✅ Configuration Complete!

All credentials have been configured:
- ✅ PostgreSQL database
- ✅ Auth0 credentials
- ✅ JWT signing key
- ✅ SMTP configuration

## Quick Start

### 1. Create .env File

```bash
cd accounts/api
cp env-production.txt .env
```

The `.env` file is now ready with all your credentials!

### 2. Install Dependencies

```bash
npm install
```

### 3. Build the Application

```bash
npm run build
```

### 4. Test Locally (Optional)

```bash
npm start
```

The server will:
- Connect to PostgreSQL database
- Run database migrations automatically
- Start on port 4000

Test it:
```bash
curl http://localhost:4000/api/health
```

### 5. Deploy to cPanel

#### Option A: Using cPanel Node.js Selector

1. **Upload Files** to your cPanel account (via File Manager or FTP)
   - Upload the entire `accounts/api` directory

2. **Create Node.js Application**:
   - Go to cPanel → Node.js Selector
   - Click "Create Application"
   - **Node.js version**: Select latest (v20 or higher)
   - **Application mode**: Production
   - **Application root**: `/home/username/accounts/api` (adjust to your path)
   - **Application URL**: `accounts.arslan10227.site`
   - **Application startup file**: `src/server.ts` (or `lib/server.js` if using built version)

3. **Set Environment Variables**:
   - In the Node.js app settings, you can either:
     - Copy all variables from `.env` file into cPanel's environment variables section
     - Or ensure `.env` file is in the application root directory

4. **Install Dependencies**:
   - Use cPanel's "Run npm install" feature
   - Or run via SSH: `cd ~/accounts/api && npm install --production`

5. **Start Application**:
   - Click "Run npm start" or "Reload App" in cPanel

#### Option B: Using SSH/PM2 (Recommended for Production)

If you have SSH access:

```bash
# Navigate to application directory
cd ~/accounts/api

# Install dependencies
npm install --production

# Build the application
npm run build

# Install PM2 globally (process manager)
npm install -g pm2

# Start the application
pm2 start lib/server.js --name accounts-api

# Save PM2 configuration
pm2 save

# Set up PM2 to start on boot
pm2 startup
# Follow the instructions it provides
```

### 6. Configure Reverse Proxy (if needed)

If cPanel doesn't handle Node.js directly, set up a reverse proxy.

#### Using .htaccess (Apache)

Create `.htaccess` in your domain's public directory:

```apache
RewriteEngine On
RewriteRule ^(.*)$ http://localhost:4000/$1 [P,L]
```

#### Using Nginx (if available)

```nginx
server {
    listen 80;
    server_name accounts.arslan10227.site;

    location / {
        proxy_pass http://localhost:4000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_cache_bypass $http_upgrade;
    }
}
```

### 7. Set Up SSL Certificate

1. **Via cPanel**:
   - Go to SSL/TLS Status
   - Select `accounts.arslan10227.site`
   - Click "Run AutoSSL" or install Let's Encrypt certificate

2. **Verify HTTPS**:
   - After SSL is installed, test: `https://accounts.arslan10227.site/api/health`

### 8. Test the API

```bash
# Health check
curl https://accounts.arslan10227.site/api/health

# Test CORS (should work from arslan10227.site)
curl -H "Origin: https://arslan10227.site" \
     -H "Access-Control-Request-Method: GET" \
     -X OPTIONS \
     https://accounts.arslan10227.site/api/get-prices

# Test pricing endpoint
curl https://accounts.arslan10227.site/api/get-prices
```

## Environment Variables Summary

All configured in `.env`:

- **Database**: PostgreSQL (`maliklaptops_httptoolkit`)
- **Auth0**: Domain, App Client, Management Client
- **JWT**: Signing key generated
- **SMTP**: `mail.arslan10227.site:465`
- **CORS**: Configured for `arslan10227.site` domains

## Troubleshooting

### Database Connection Issues

```bash
# Test PostgreSQL connection
psql -U maliklaptops_user -d maliklaptops_httptoolkit -h localhost
```

If connection fails:
- Verify PostgreSQL is running
- Check user permissions
- Verify database exists

### Port Already in Use

```bash
# Check what's using port 4000
lsof -i :4000
# or
netstat -tulpn | grep 4000
```

Change PORT in `.env` if needed.

### SMTP Connection Issues

Test SMTP connection:
```bash
# Using Node.js
node -e "
const nodemailer = require('nodemailer');
const transporter = nodemailer.createTransport({
  host: 'mail.arslan10227.site',
  port: 465,
  secure: true,
  auth: {
    user: 'admin@arslan10227.site',
    pass: 'Arslan@10227.'
  }
});
transporter.verify((error, success) => {
  if (error) {
    console.log('SMTP Error:', error);
  } else {
    console.log('SMTP Server is ready');
  }
});
"
```

### Check Logs

```bash
# PM2 logs
pm2 logs accounts-api

# Application logs (if configured)
tail -f ~/accounts/api/logs/app.log
```

## Security Checklist

- [x] `.env` file contains all credentials
- [ ] `.env` file is NOT in public_html (keep it secure)
- [ ] Database password is strong
- [ ] JWT key is secure
- [ ] SSL certificate installed
- [ ] CORS properly configured
- [ ] Rate limiting enabled (built-in)

## Next Steps After Deployment

1. **Build and Deploy UI**:
   ```bash
   cd httptoolkit-ui
   export ACCOUNTS_API=https://accounts.arslan10227.site/api
   npm install
   npm run build
   # Deploy dist/ to arslan10227.site
   ```

2. **Test Complete Flow**:
   - Open `https://arslan10227.site`
   - Try logging in
   - Verify email codes are sent
   - Test contact form

3. **Monitor**:
   - Check application logs regularly
   - Monitor database connections
   - Verify email delivery

## Support

If you encounter issues:
1. Check application logs
2. Verify all environment variables are set
3. Test database and SMTP connections separately
4. Review `DEPLOYMENT.md` for detailed instructions
