# cPanel Deployment Guide - Accounts API

## ✅ Build Complete!

The application is ready for deployment. Since this uses `tsx` to run TypeScript directly, you need to upload the source files.

## Files to Upload to cPanel

Upload these files and directories to your cPanel account:

### Required Files & Directories:

```
accounts-api/
├── src/                    # Source TypeScript files (REQUIRED)
│   ├── server.ts          # Main server file
│   ├── db/                # Database files
│   ├── email/             # Email templates
│   ├── functions/         # API functions
│   └── ...                # All other source files
├── custom-typings/        # Type definitions (REQUIRED)
├── node_modules/          # Dependencies (REQUIRED - or install via npm)
├── package.json           # Package configuration (REQUIRED)
├── package-lock.json      # Lock file (REQUIRED)
├── tsconfig.json          # TypeScript config (REQUIRED)
├── .env                   # Environment variables (REQUIRED - create from env-production.txt)
└── README-DEPLOY.md       # This file (optional)
```

## Step-by-Step Deployment

### Step 1: Prepare .env File

On your local machine:

```bash
cd accounts/api
cp env-production.txt .env
```

**Verify `.env` contains:**
- Database connection
- Auth0 credentials
- JWT signing key
- SMTP configuration

### Step 2: Upload Files to cPanel

**Option A: Using cPanel File Manager**

1. Log into cPanel
2. Go to **File Manager**
3. Navigate to your home directory (or create `accounts-api` folder)
4. Upload all files and folders:
   - `src/` directory
   - `custom-typings/` directory
   - `package.json`
   - `package-lock.json`
   - `tsconfig.json`
   - `.env` file (IMPORTANT: Keep this secure!)

**Option B: Using FTP/SFTP**

1. Connect via FTP client (FileZilla, WinSCP, etc.)
2. Upload entire `accounts/api` directory structure
3. Ensure `.env` file is uploaded

### Step 3: Create Node.js Application in cPanel

1. Go to cPanel → **Node.js Selector**
2. Click **"Create Application"**
3. Fill in the details:
   - **Node.js version**: Select latest (v20 or higher)
   - **Application mode**: Production
   - **Application root**: `/home/username/accounts-api` (adjust to your path)
   - **Application URL**: `accounts.arslan10227.site`
   - **Application startup file**: `src/server.ts`
   - **Application port**: `4000` (or your chosen port)

### Step 4: Set Environment Variables

In the Node.js application settings:

1. Click on your application
2. Go to **"Environment Variables"** section
3. Add all variables from `.env` file:
   - `PORT=4000`
   - `NODE_ENV=production`
   - `DATABASE_URL=postgresql://...`
   - `AUTH0_DOMAIN=...`
   - `AUTH0_APP_CLIENT_ID=...`
   - `AUTH0_APP_CLIENT_SECRET=...`
   - `AUTH0_MGMT_CLIENT_ID=...`
   - `AUTH0_MGMT_CLIENT_SECRET=...`
   - `SIGNING_PRIVATE_KEY=-----BEGIN RSA PRIVATE KEY-----...`
   - `SMTP_HOST=...`
   - `SMTP_PORT=465`
   - `SMTP_IS_SECURE=true`
   - `SMTP_USERNAME=...`
   - `SMTP_PASSWORD=...`
   - `CONTACT_FORM_DESTINATION=...`
   - `ORIGIN_REGEX=...`

**OR** ensure `.env` file is in the application root directory.

### Step 5: Install Dependencies

In cPanel Node.js application:

1. Click **"Run npm install"** button
2. Wait for installation to complete
3. Check for any errors

**OR** via SSH (if available):
```bash
cd ~/accounts-api
npm install --production
```

### Step 6: Start the Application

1. Click **"Run npm start"** or **"Reload App"**
2. Check the logs for any errors
3. Verify it's running on the configured port

### Step 7: Configure Reverse Proxy (if needed)

If cPanel doesn't handle Node.js routing automatically:

**Using .htaccess (Apache):**

Create `.htaccess` in your domain's public directory:

```apache
RewriteEngine On
RewriteRule ^(.*)$ http://localhost:4000/$1 [P,L]
```

**Using Nginx (if available):**

```nginx
server {
    listen 80;
    server_name accounts.arslan10227.site;

    location / {
        proxy_pass http://localhost:4000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_cache_bypass $http_upgrade;
    }
}
```

### Step 8: Set Up SSL Certificate

1. Go to cPanel → **SSL/TLS Status**
2. Select `accounts.arslan10227.site`
3. Click **"Run AutoSSL"** or install Let's Encrypt certificate
4. Wait for certificate installation

### Step 9: Test the API

```bash
# Health check
curl https://accounts.arslan10227.site/api/health

# Should return: OK
```

## Troubleshooting

### Application Won't Start

1. **Check Logs**: View application logs in cPanel Node.js
2. **Verify Environment Variables**: Ensure all are set correctly
3. **Check Port**: Ensure port 4000 is available
4. **Database Connection**: Verify PostgreSQL is accessible

### Database Connection Errors

```bash
# Test PostgreSQL connection (via SSH if available)
psql -U maliklaptops_user -d maliklaptops_httptoolkit -h localhost
```

### SMTP Errors

- Verify SMTP credentials are correct
- Check port 465 is not blocked
- Test SMTP connection separately

### CORS Errors

- Verify `ORIGIN_REGEX` includes your domain
- Check Origin header in requests
- Review server logs for CORS warnings

## Security Checklist

- [ ] `.env` file is NOT in public_html
- [ ] `.env` file has correct permissions (600 or 640)
- [ ] Environment variables are set in cPanel
- [ ] SSL certificate is installed
- [ ] Database password is strong
- [ ] Application is running in production mode

## File Structure on cPanel

```
/home/username/
├── accounts-api/          # Your application directory
│   ├── src/
│   ├── custom-typings/
│   ├── node_modules/
│   ├── package.json
│   ├── .env              # Keep secure!
│   └── ...
└── public_html/
    └── accounts.arslan10227.site/  # Domain directory (if using reverse proxy)
        └── .htaccess      # Reverse proxy config
```

## Next Steps

After successful deployment:

1. **Test API endpoints**
2. **Build and deploy UI** to `arslan10227.site`
3. **Test complete authentication flow**
4. **Monitor logs** for any issues

## Support

If you encounter issues:
1. Check application logs in cPanel
2. Verify all environment variables
3. Test database and SMTP connections
4. Review error messages in logs

Good luck with your deployment! 🚀
